
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Data.SqlClient;
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_Rack : BaseTest 
	{		
		
		private DataTable _dtRack;
		private DataTable _dtDailyQcWorklist;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//***Get the Rack data, Racks die easily, so we dont exception on no recs found - then update
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE DailyControlGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist)" , false);
				if (this._dtRack.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("UPDATE Rack SET RecordStatusCode = 'A' WHERE DailyControlGuid IN (SELECT TOP 1 DailyControlGUid FROM Rack WHERE DailyControlGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "')");
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE DailyControlGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist)", true);
				}				
				this._dtDailyQcWorklist = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyQcWorklist WHERE RackGuid = '" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetDailyQCRacks_Pass()
		{
			DataTable dtTest = DAL.Rack.GetDailyQCRacks(BOL.VBECSDateTime.GetDivisionCurrentDateTime());

			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.DailyQcExpirationDate), TABLES.DailyQcWorklist.DailyQcExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.DailyQcWorklistGuid), TABLES.DailyQcWorklist.DailyQcWorklistGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.PartiallyTestedIndicator), TABLES.DailyQcWorklist.PartiallyTestedIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.DailyUseIndicator), TABLES.DailyQcWorklist.DailyUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RowVersion), TABLES.Rack.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.LastUpdateDate), TABLES.Rack.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.DivisionCode), TABLES.Rack.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.LastUpdateUser), TABLES.Rack.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.DailyControlGuid), TABLES.DailyControl.DailyControlGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.RackNamesIndicator), TABLES.DailyControl.RackNamesIndicator);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.CommercialTemplateIndicator), TABLES.DailyControl.CommercialTemplateIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.DailyAlertTime), TABLES.DailyControl.DailyAlertTime);
		}

		[Test]
		[ExpectedException(typeof(SqlException))]
		public void GetDailyQCRacks_Fail()
		{
			DAL.Rack.GetDailyQCRacks(System.DateTime.Now.AddYears(-75));
		}

		[Test]
		public void UpdateRackDailyUse_Pass()
		{
			this.RefreshData = true;

			System.Guid worklistGuid = (System.Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			byte[] rowVersion = (byte[])this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.RowVersion];

			//Test an update
			bool retValue = DAL.Rack.UpdateRackDailyUse(worklistGuid, true, true, Common.UpdateFunction.UnitTests, rowVersion, rackGuid, System.DateTime.Now);
			Assert.AreEqual(true, retValue, "Update");

			//Test an insert
			retValue = DAL.Rack.UpdateRackDailyUse(System.Guid.Empty, true, true, Common.UpdateFunction.UnitTests, rowVersion, rackGuid, System.DateTime.Now);
			Assert.AreEqual(true, retValue, "Insert");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateRackDailyUse_Fail()
		{
			System.Guid worklistGuid = (System.Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			byte[] rowVersion = new byte[8];

			DAL.Rack.UpdateRackDailyUse(worklistGuid, true, true, Common.UpdateFunction.UnitTests, rowVersion, rackGuid, System.DateTime.Now);

		}

		[Test]
		public void GetConfigurableRackQC_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.DailyControlGuid];

			DataTable dtTest = DAL.Rack.GetConfigurableRackQC(unitGuid);

			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.DailyControlGuid), TABLES.Rack.DailyControlGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RecordStatusCode), TABLES.Rack.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.DivisionCode), TABLES.Rack.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RowVersion), TABLES.Rack.RowVersion);
		}

		[Test]
		public void GetConfigurableRackQC_Fail()
		{
			DataTable dtTest = DAL.Rack.GetConfigurableRackQC(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetRack_Pass()
		{
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			DataTable dtTest = DAL.Rack.GetRack(rackGuid);

			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.DailyControlGuid), TABLES.Rack.DailyControlGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.DailyQcExpirationDate), TABLES.DailyQcWorklist.DailyQcExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.DailyUseIndicator), TABLES.DailyQcWorklist.DailyUseIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyQcWorklist.PartiallyTestedIndicator), TABLES.DailyQcWorklist.PartiallyTestedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.SortColumn), TABLES.Rack.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.DivisionCode), TABLES.Rack.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RecordStatusCode), TABLES.Rack.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.LastUpdateDate), TABLES.Rack.LastUpdateDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RowVersion), TABLES.Rack.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.LastUpdateUser), TABLES.Rack.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.LastUpdateFunctionId), TABLES.Rack.LastUpdateFunctionId);
		}

		[Test]
		public void GetRack_Fail()
		{
			DataTable dtTest = DAL.Rack.GetRack(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetRackTestDate_Pass()
		{
			System.Guid worklistGuid = (System.Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			
			DataTable dtTest = DAL.Rack.GetRackTestDate(worklistGuid);

			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotUseDate), TABLES.RackLot.LotUseDate);
		}

		[Test]
		public void GetRackTestDate_Fail()
		{
			DataTable dtTest = DAL.Rack.GetRackTestDate(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
	}
}
#endif


